/******************************************************************************
 *
 * PROJECT:  	Virtual Phone (Dyonisus)
 * FILE:     	CDllLoader.h
 * AUTHOR:	 	Kevin Alet
 *
 * DESCRIPTION:	
 *				Load and unLoad Virtual phone's DLLs
 *
 * REVISION HISTORY:
 * 05/04/03		Kal		Initial version.
 * --/--/--		---		
 *
 *****************************************************************************/
/*
 ==============================================================================
 Copyright (c) PalmSource, Inc.
 All rights reserved.
 ==============================================================================
 */

#if !defined(AFX_DLLLOADER_H__E5471BB4_1EE5_48D0_8B47_8CF854E82DC4__INCLUDED_)
#define AFX_DLLLOADER_H__E5471BB4_1EE5_48D0_8B47_8CF854E82DC4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#include "atlstr.h"
#include "VPIncs.h"
#include "FileUtil.h"

#define kLnkSectionKey			"LinkDllLoader"
#define kSvcSectionKey			"ServiceDllLoader"
#define kNbLoadedDll			"NbDll"
#define kDllName				"DllName"

/////////////////////////////////////////////////////////////////////////////
#define resetPtr(ptr) if(ptr!=NULL){delete ptr; ptr=NULL;}
#define MAX_REQUIRED_DLL		20

typedef VOID* (*VPDLLPROC) ();
typedef UInt16 (*VPDLLPROC2) (char**);
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CConfigDllLoader
{
private:
	CString			mSectionKey;
public:
	char**			mNamePP;
	int				mCount;
public:
	Bool			Load();
	Bool			Save();
	void			FreeParams();
	Bool			Init(int iCount);
public:
	CConfigDllLoader(char* iSectionKeyP)	{ mSectionKey = iSectionKeyP; mCount = 0; mNamePP = NULL;};
	~CConfigDllLoader()						{ FreeParams(); };
};
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CDllParams
{
public:
	CString		mFullFileName;
	CString		mFileName;
	CString		mFilePath;
	CString		mDllIdent;
	CString		mDllType;
	CString		mDllName;
	CString		mDllVersion;
	CString		mRequiredDll;
	HINSTANCE	mHinst;
	void*		mDllManager;
public:
	CDllParams();
	~CDllParams();
};
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CDllLoader  
{
public:
	CDllLoader(Bool iInstanciate=true, Bool iDllType=false);
	virtual ~CDllLoader();

	Bool		DllLoadAll();
	CDllParams*	DllLoad(CString iFullFileName);
	void		DllUnload(CDllParams* iDllP);
	void		DllUnloadAll();
	Bool		CheckAndValidate(bool iUnLoadDefault=false);
	Bool		DllCheck(CDllParams* iDllP);
	Bool		DllCheck(CString iFullFileName);
	UInt16		DllGetCount();
	CDllParams* DllGetParams(UInt16 index);
	CDllParams* DllGetParams(CString iFullFileName);
	void*		DllGetManager(UInt16 index, Bool iInstanciate = false);
	char*		CfgGetSection();
	void		CfgUpdate();
	// To remove
	Bool		IsLinkMode() { return linkMode; };	
	Bool		CfgSave();
private:
	int			linkMode;
	//Bool		PrvLoad();	
	CDllParams* mTmpDllP;
	CConfigDllLoader* mConfigP;
	CList<CDllParams*,CDllParams*> mDllList;
	Bool		mInstanciate;
private:
	CDllParams* PrvDllLoad(CString iFullFileName, Bool iSilent=false);
	void*		PrvDllRunMethod(HINSTANCE iHInst, char* iMethodNameP);
	Bool		PrvDllIsLoaded(CString iFullFileName);
	char**		PrvDllGetDependencies(UInt16& oNbEntries,HINSTANCE iHinst);				
	
};
/////////////////////////////////////////////////////////////////////////////
#endif // !defined(AFX_DLLLOADER_H__E5471BB4_1EE5_48D0_8B47_8CF854E82DC4__INCLUDED_)
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
